/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

//#include <csl_types.h>

#define COMP_MODE_CTRL_0t	0xFFFE100C  /* Mode Control reg         */
#define MUX_CTRL_REG_6		0xFFFE101C  /* Mux  Control reg         */
#define ARM_IDLECT2			0xFFFECE08
#define ARM_RSTCT2			0xFFFECE14
#define GPIO1_DIRECTIONt		0xFFFBE434
#define GPIO1_DATAOUTt		0xFFFBE430
#define LCD_CONTROL			0xFFFEC000  /* Active Panel display     */
#define LCD_STATUS			0xFFFEC010  /* Lcd Status reg           */
#define PWL_CONTROL			0xFFFB5804  /* Pulse width clock        */
#define PWL_LEVEL			0xFFFB5800  /* set pulse width value    */

#define COMP_MODE_CTRL_VAL		0xEAEF  /* Mode Control value       */
#define MUX_CTRL_REG_6_VAL		0x38    /* Multiplexing Value       */
#define MUX_CTRL_REG_6_BL_VAL	0x08    /* Back light Sel Value     */
#define MUX_CTRL_REG_6_SEL		0xFFFF81FF  /* select mux reg           */
#define MUX_CTRL_REG_6_OPR		0x2400  /* Mux reg operation val    */
#define BP_VAL					0x04    /* Board powerup Val        */
#define EN_LCDCK				0x0008  /* Enable LCD Clock         */
#define LcdEn					0x01    /* Enable LCD controller    */
#define LcdTFT					0x80    /* Enable Active display    */
#define PWL_LEVEL_VAL			0xFF    /* Back Light Value         */
#define EN_PWL_CLK				0x01    /* Enable pulse width clock */

#define	ARM_CKCTL		0xFFFECE00  /* MPU CLOCK CONTROL PRESCALER SELECTION    */
#define LCD_CONTROL		0xFFFEC000  /* LCD CONTROL REGISTER                     */
#define LCD_TIMING0		0xFFFEC004  /* LCD TIMING REGISTER 0                    */
#define LCD_TIMING1		0xFFFEC008  /* LCD TIMING REGISTER 1                    */
#define LCD_TIMING2		0xFFFEC00C  /* LCD TIMING REGISTER 2                    */
#define LCD_STATUS		0xFFFEC010  /* Lcd STATUS REGISTER                      */
#define LCD_LINEINT		0xFFFEC018  /* LCD LINE INTERRUPT REGISTER              */

/* Pointer for conversion control Register */
#define LCDCONV_CONTROL		0xFFFE3080
#define DMA_LCD_CTRL		0xFFFEDB00  /* DMA LCD ctrl Reg                         */
#define DMA_LCD_TOP_F1_L	0xFFFEDB02  /* Lower 16 bit of frame buff1 start addr   */
#define DMA_LCD_TOP_F1_U	0xFFFEDB04  /* Upper 16 bit of frame buff1 start addr   */
#define DMA_LCD_BOT_F1_L	0xFFFEDB06  /* Lower 16 bit of frame buff1 end addr     */
#define	DMA_LCD_BOT_F1_U	0xFFFEDB08  /* Upper 16 bit of frame buff1 end addr     */

#define LT0_VAL			0x06061CEF  /* Timer Zero Value                         */
#define LT1_VAL			0x0000513F  /* Timer One Value                          */
#define LT2_VAL			0x03300011  /* Timer Two Value                          */
#define LCD_LINEINT_VAL	0x13F   /* Interrupt En Value                       */
#define LCDCONV_CONTROL_VAL	0x07    /* Enable LCD ctrl Vale                     */

/* FRAME BUFFER START ADDRESS */
//#define PALETTE           0x11E00000      /* Lower 16 addr of frame buff */
//#define FRAME_BUFFER  0x11E00020      /* Lower 16 addr of frame buff */
#include "mem_address.h"
#define PALETTE			(FRAME_BUFFER_address-0x20) /* Lower 16 addr of frame buff */
#define FRAME_BUFFER	(FRAME_BUFFER_address)  /* Lower 16 addr of frame buff */
void    lcdConfig();
void    dmaLcdConfig();
void    frameBuffFill(int s32Color);
void    lcd();
void    yuv420rgb16(unsigned char *, unsigned char *, unsigned char *,
                    unsigned short *, int, int, int, int);
